
import cv2 as cv
import numpy as np

class MyDescriptorExtractor:
    def __init__(self, extractorType = cv.ORB):
        self.myDescriptorExtractorType = extractorType
        self.myDescriptorExtractor = None
        self.myDescriptors = None
        self.changeDescriptorExtractor(extractorType)

    def changeDescriptorExtractor(self, extractorType):
        # First release the previous extractor
        if self.myDescriptorExtractor is not None:
            self.myDescriptorExtractor.release()
        
        # and we store the method
        self.myDescriptorExtractorType = extractorType

        # Depending on the extractor type we will create the correponsding corner detector
        if extractorType == cv.ORB:
            # TODO: create and store extractor using cv.ORB_create()
            pass # TODO: remove this line

    # Setting the image to extract descriptors from
    def setImage(self, image):
        self.image = image
    
    # Setting the keypoints to extract descriptors from
    def setFeatures(self, features):
        self.features = features
    
    # Compute the descriptors of the stored image and features
    def computeDescriptors(self):
        if self.myDescriptors is not None:
            self.myDescriptors.clear()

        # TODO: compute descriptors
        
        return self.myDescriptors

    # Return the descriptors
    def getDescriptors(self):
        return self.myDescriptors
    
    # Getting the current descriptor extractor method used
    def getDescriptorExtractor(self):
        return self.myDescriptorExtractorType

    # Getting the name of the extractor
    def getDescriptorExtractorName(self):
        return self.getDescriptorExtractorName(self.myDescriptorExtractorType)

    # Getting the name of the extractor
    def getDescriptorExtractorName(self, extractorType):
        if(extractorType == cv.ORB):
            return "ORB"
        if(extractorType == cv.BRISK):
            return "BRISK"
        if(extractorType == cv.AKAZE):
            return "AKAZE"
        if(extractorType == cv.MSER):
            return "MSER"
        return "Unknown"
